using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

namespace Enhanced_List_Box_Control
{
	/// <summary>
	/// Summary description for Frm_Enhanced_List_box_Control.
	/// </summary>
	public class Frm_Enhanced_List_box_Control : System.Web.UI.Page
	{
		protected System.Web.UI.WebControls.ListBox lstEmployees;
		protected System.Web.UI.WebControls.Button btnaddall;
		protected System.Web.UI.WebControls.Button btnadditem;
		protected System.Web.UI.WebControls.Button btnremoveitem;
		protected System.Web.UI.WebControls.Button btnremoveall;
		protected System.Web.UI.WebControls.ListBox lstSelectedEmployees;
		protected System.Web.UI.WebControls.Button btnColmoveup;
		protected System.Web.UI.WebControls.Button btnColmovedwn;
	
		private void Page_Load(object sender, System.EventArgs e)
		{
			// Put user code to initialize the page here
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.btnaddall.Click += new System.EventHandler(this.btnaddall_Click);
			this.btnadditem.Click += new System.EventHandler(this.btnadditem_Click);
			this.btnremoveitem.Click += new System.EventHandler(this.btnremoveitem_Click);
			this.btnremoveall.Click += new System.EventHandler(this.btnremoveall_Click);
			this.btnColmoveup.Click += new System.EventHandler(this.btnColmoveup_Click);
			this.btnColmovedwn.Click += new System.EventHandler(this.btnColmovedwn_Click);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion


		private void MoveUp(ListBox lstBox)
		{
			int                  iIndex, iCount, iOffset, iInsertAt,iIndexSelectedMarker = -1;
			string               lItemData,lItemval;
			try
			{
			
				// Get the count of items in the list control
				iCount = lstBox.Items.Count;

				// Set the base loop index and the increment/decrement value based on the direction the item are being moved (up or down).
				iIndex  =  0;
				iOffset =  -1;
    
				// Loop through all of the items in the list.
				while(iIndex < iCount) 
				{
					// Check if this item is selected.
					if(lstBox.SelectedIndex > 0)
					{
						// Get the item data for this item
						lItemval =lstBox.SelectedItem.Value.ToString();
						lItemData = lstBox.SelectedItem.Text.ToString() ;
						iIndexSelectedMarker=lstBox.SelectedIndex; 

						// Don't move selected items past other selected items
						if(-1 != iIndexSelectedMarker)
						{
							for(int iIndex2 = 0; iIndex2 < iCount; ++iIndex2)
							{
								// Find the index of this item in enabled list
								if( lItemval == lstBox.Items[iIndex2].Value.ToString())
								{
									// Remove the item from its current position
									lstBox.Items.RemoveAt(iIndex2);

									// Reinsert the item in the array one space higher than its previous position
									iInsertAt = (iIndex2 + iOffset) < 0 ? 0 : iIndex2 + iOffset;
									ListItem li = new ListItem(lItemData,lItemval);
									lstBox.Items.Insert(iInsertAt,li);
									break;
								}
							}
						}
					}
						// If this item wasn't selected save the index so we can check it later so we don't move past the any selected items.
					else if(-1 == iIndexSelectedMarker)
					{
						iIndexSelectedMarker = iIndex;
						break;
				
					}

					iIndex = iIndex + 1;
				}

				if(iIndexSelectedMarker==0)
					lstBox.SelectedIndex=iIndexSelectedMarker;
				else
					lstBox.SelectedIndex=iIndexSelectedMarker-1;
			}
			catch(Exception expException)
			{
				Response.Write(expException.Message); 
			}

		}

		private void MoveDown(ListBox lstBox)
		{
			try
			{
				int                  iIndex, iCount, iOffset, iInsertAt,iIndexSelectedMarker = -1;
				string               lItemData;
				string				 lItemval;

			
				// Get the count of items in the list control
				iCount = lstBox.Items.Count;
			
				// Set the base loop index and the increment/decrement value based on the direction the item are being moved (up or down).
				iIndex  =  iCount - 1;
				iOffset =  1;
    
				// Loop through all of the items in the list.
				while(iIndex >= 0) 
				{
					// Check if this item is selected.
					if(lstBox.SelectedIndex >= 0)
					{
						// Get the item data for this item
						lItemData = lstBox.SelectedItem.Text.ToString();
						lItemval =lstBox.SelectedItem.Value.ToString();
						iIndexSelectedMarker=lstBox.SelectedIndex; 

						// Don't move selected items past other selected items
						if(-1 != iIndexSelectedMarker)
						{
							for(int iIndex2 = 0; iIndex2 < iCount-1; ++iIndex2)
							{
								// Find the index of this item in enabled list
								if( lItemval == lstBox.Items[iIndex2].Value.ToString())
								{
									// Remove the item from its current position
								
									lstBox.Items.RemoveAt(iIndex2);

									// Reinsert the item in the array one space higher than its previous position
									iInsertAt = (iIndex2 + iOffset) < 0 ? 0 : iIndex2 + iOffset;
									ListItem li = new ListItem(lItemData,lItemval);
									lstBox.Items.Insert(iInsertAt,li);
									break;
									
								}
							}
						}
					}
					iIndex = iIndex - 1;
				}
				if(iIndexSelectedMarker==lstBox.Items.Count-1)
					lstBox.SelectedIndex=iIndexSelectedMarker;
				else
					lstBox.SelectedIndex=iIndexSelectedMarker+1;
			}
			catch(Exception expException)
			{
				Response.Write(expException.Message);
			}
		}

		private void AddRemoveAll(ListBox aSource, ListBox aTarget)
		{
			
			try
			{

				foreach(ListItem item in aSource.Items)
				{
					aTarget.Items.Add(item);
				}
				aSource.Items.Clear();
			
			}
			catch(Exception expException)
			{
				Response.Write(expException.Message);
			}

		}

		private void AddRemoveItem(ListBox aSource, ListBox aTarget)
		{
			
			ListItemCollection licCollection;

			try
			{
				
				licCollection = new ListItemCollection();
				for(int intCount=0; intCount<aSource.Items.Count;intCount++)
				{
					if(aSource.Items[intCount].Selected==true)
						licCollection.Add(aSource.Items[intCount]); 
				}
			
				for(int intCount=0; intCount<licCollection.Count;intCount++)
				{
					aSource.Items.Remove(licCollection[intCount]);
					aTarget.Items.Add(licCollection[intCount]);
				}

			}
			catch(Exception expException)
			{
				Response.Write(expException.Message);
			}
			finally
			{
				licCollection = null;
			}

		}

		private void btnaddall_Click(object sender, System.EventArgs e)
		{
				AddRemoveAll(lstEmployees,lstSelectedEmployees);
		
		}

		private void btnadditem_Click(object sender, System.EventArgs e)
		{
		AddRemoveItem(lstEmployees,lstSelectedEmployees);
		}

		private void btnremoveitem_Click(object sender, System.EventArgs e)
		{
		AddRemoveItem(lstSelectedEmployees,lstEmployees);
		}

		private void btnremoveall_Click(object sender, System.EventArgs e)
		{
		AddRemoveAll(lstSelectedEmployees,lstEmployees);
		}

		private void btnColmoveup_Click(object sender, System.EventArgs e)
		{
		MoveUp(lstSelectedEmployees);
		}

		private void btnColmovedwn_Click(object sender, System.EventArgs e)
		{
		MoveDown(lstSelectedEmployees);
		}

	}
}
